//Exp 3.2 Program Title:Quantization of grey scale image using 5,6,7 and 8 bits per pixels
///environment: Scilab 5.5.2
//Toolbox: Image Processing Design 8.3.1-1
//Toolbox: SIVP 0.5.3.2
//Tested on OS: Windows 7 Professional, 64 bit
//Reference books names : 1)Digital Image Processing book author :
// Rafael C.Gonzalez and Richard E.Woods,
//2)Digital Image Processing book author :S.Sudhir,
//3)Digital Image Processing book author :Dhanajay Theckedath
clc //to clear command window.
clear all //to disable previously defined variables.
xdel(winsid());///clear all the previous figures plots
SIVP_PATH = getSIVPpath(); //to locate a directory in which SIVP toolbox is installed
ii1=imread(SIVP_PATH + 'images/rose.bmp');//read second color image from diractory
ii=rgb2gray(ii1);//to convert an image into grayscale image.
t1=quag(ii,8);//quantization by using 8 bits i.e 256 gray level
t2=quag(ii,7);//quantization by using 7 bits i.e 128 gray level
t3=quag(ii,6);//quantization by using 6 bits i.e 64 gray level
t4=quag(ii,5);//quantization by using 5 bits i.e 32 gray level
figure(1);ShowImage(ii,'original gray image having size 256 x 384');title('original grey image','color','red','fontsize',5);//IPD tool box
figure(2);ShowImage(t1,'Quantized using 256 grey level');title('Quantized using 256 grey level','color','red','fontsize',5');//IPD tool box
figure(3);ShowImage(t2,'Quantized using 128 grey level');title('Quantized using 128 grey level','color','red','fontsize',5);//IPD tool box
figure(4);ShowImage(t3,'Quantized using 64 grey level');title('Quantized using 64 grey level','color','red','fontsize',5);//IPD tool box
figure(5);ShowImage(t4,'Quantized using 32 grey level');title('Quantized using 32 grey level','color','red','fontsize',5);//IPD tool box
